defmodule PosEngine.Repo.Migrations.CreateStores do
  use Ecto.Migration

  def change do
    create table(:stores) do
      add(:external_id, :string)
      add(:name, :string)
      add(:email, :string)
      add(:phone, :string)
      add(:address_line1, :string)
      add(:address_line2, :string)
      add(:city, :string)
      add(:state, :string)
      add(:zipcode, :string)
      add(:latitude, :float)
      add(:longitude, :float)
      add(:currency_option, :map)
      add(:active, :boolean, default: true)
      add(:account_id, references(:accounts, on_delete: :nothing))
      timestamps()
    end

    create(unique_index(:stores, [:account_id, :name]))
  end
end
