defmodule PosEngine.Repo.Migrations.CreateCourses do
  use Ecto.Migration

  def change do
    create table(:courses) do
      add(:name, :string)
      add(:external_id, :string)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))
      timestamps()
    end

    create(unique_index(:courses, [:store_id, :name]))
  end
end
