defmodule PosEngine.Repo.Migrations.CreatePaymentOptions do
  use Ecto.Migration

  def change do
    create table(:payment_options) do
      add(:payment_name, :string)
      add(:payment_type, :string)
      add(:external_id, :string)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))
      timestamps()
    end

    create(unique_index(:payment_options, [:store_id, :payment_name]))
  end
end
