defmodule PosEngine.Repo.Migrations.CreateCharges do
  use Ecto.Migration

  def change do
    create table(:charges) do
      add(:name, :string)
      add(:external_id, :string)
      add(:open_charge, :boolean)
      add(:percentage, :integer)
      add(:service_types, {:array, :integer})
      add(:amount, :integer)
      add(:applied, :boolean)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))

      timestamps()
    end

    create(unique_index(:charges, [:store_id, :name]))
  end
end
