defmodule PosEngine.Repo.Migrations.CreateItemDiscounts do
  use Ecto.Migration

  def change do
    create table(:item_discounts) do
      add(:name, :string)
      add(:external_id, :string)
      add(:adjust_amount, :integer)
      add(:auto_discount, :boolean)
      add(:time_applicable, :map)
      add(:offer, :integer)
      add(:offer_in, :integer)
      add(:percentage, :integer)
      add(:discount_type, :integer, default: 2)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))

      timestamps()
    end

    create(unique_index(:item_discounts, [:store_id, :name]))
  end
end
