defmodule PosEngine.Repo.Migrations.CreateAccounts do
  use Ecto.Migration

  def change do
    create table(:accounts) do
      add(:name, :string)
      add(:external_id, :string)
      add(:currency_option, :map)
      add(:country_id, :integer)
      add(:time_zone, :string)
      add(:active, :boolean, default: true)
      add(:application_id, references(:applications))
      timestamps()
    end

    create(unique_index(:accounts, [:application_id, :name]))
  end
end
