defmodule PosEngine.Repo.Migrations.CreateMenuitems do
  use Ecto.Migration

  def change do
    create table(:menu_items) do
      add(:name, :string)
      add(:external_id, :string)
      add(:short_name, :string)
      add(:image_available, :boolean)
      add(:image_version, :integer)
      add(:tags, :string)
      add(:description, :string)
      add(:varying, :boolean)
      add(:active, :boolean, default: true)
      add(:modifier_receipe_id, :integer)
      add(:store_id, references(:stores))

      timestamps()
    end

    create(unique_index(:menu_items, [:store_id, :name]))
  end
end
