defmodule PosEngine.Repo.Migrations.CreateCheckDiscounts do
  use Ecto.Migration

  def change do
    create table(:check_discounts) do
      add(:name, :string)
      add(:external_id, :string)
      add(:adjust_amount, :integer)
      add(:auto_discount, :boolean)
      add(:time_applicable, :map)
      add(:offer, :integer)
      add(:minimum_amount, :integer)
      add(:percentage, :integer)
      add(:discount_type, :integer, default: 1)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))

      timestamps()
    end

    create(unique_index(:check_discounts, [:store_id, :name]))
  end
end
