defmodule PosEngine.Repo.Migrations.CreateCategories do
  use Ecto.Migration

  def change do
    create table(:categories) do
      add(:name, :string)
      add(:external_id, :string)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))
      timestamps()
    end

    create(unique_index(:categories, [:store_id, :name]))
  end
end
