defmodule PosEngine.Repo.Migrations.CreateInstructions do
  use Ecto.Migration

  def change do
    create table(:instructions) do
      add(:instruction, :string)
      add(:external_id, :string)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))
      timestamps()
    end

    create(unique_index(:instructions, [:store_id, :instruction]))
  end
end
