defmodule PosEngine.Repo.Migrations.CreateRoles do
  use Ecto.Migration

  def change do
    create table(:roles) do
      add(:name, :string)
      add(:default, :boolean)
      add(:priviliges, {:array, :string})
      add(:external_id, :string)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))
      timestamps()
    end

    create(unique_index(:roles, [:store_id, :name]))
  end
end
