defmodule PosEngine.Repo.Migrations.CreateTaxes do
  use Ecto.Migration

  def change do
    create table(:taxes) do
      add(:name, :string)
      add(:percentage, :integer)
      add(:type, :string)
      add(:external_id, :string)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))

      timestamps()
    end

    create(unique_index(:taxes, [:store_id, :name]))
  end
end
