defmodule PosEngine.Repo.Migrations.CreateServingsizes do
  use Ecto.Migration

  def change do
    create table(:serving_sizes) do
      add(:name, :string)
      add(:external_id, :string)
      add(:active, :boolean, default: true)
      add(:store_id, references(:stores))
      timestamps()
    end

    create(unique_index(:serving_sizes, [:store_id, :name]))
  end
end
